"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, domain: str, user_pool_id: str, custom_domain_config: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new domain for a user pool.

    Args:
        domain(str): The domain string.
        user_pool_id(str): The user pool ID.
        custom_domain_config(Dict, optional): The configuration for a custom domain that hosts the sign-up and sign-in webpages for your application. Provide this parameter only if you want to use a custom domain for your user pool. Otherwise, you can exclude this parameter and use the Amazon Cognito hosted domain instead. For more information about the hosted domain and custom domains, see Configuring a User Pool Domain. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.user.pool.domain.create(
                ctx, domain=value, user_pool_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.user.pool.domain.create domain=value, user_pool_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="create_user_pool_domain",
        op_kwargs={
            "Domain": domain,
            "UserPoolId": user_pool_id,
            "CustomDomainConfig": custom_domain_config,
        },
    )


async def delete(hub, ctx, domain: str, user_pool_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a domain for a user pool.

    Args:
        domain(str): The domain string.
        user_pool_id(str): The user pool ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.user.pool.domain.delete(
                ctx, domain=value, user_pool_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.user.pool.domain.delete domain=value, user_pool_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="delete_user_pool_domain",
        op_kwargs={"Domain": domain, "UserPoolId": user_pool_id},
    )


async def describe(hub, ctx, domain: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a domain.

    Args:
        domain(str): The domain string.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.user.pool.domain.describe(ctx, domain=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.user.pool.domain.describe domain=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="describe_user_pool_domain",
        op_kwargs={"Domain": domain},
    )


async def update(
    hub, ctx, domain: str, user_pool_id: str, custom_domain_config: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the Secure Sockets Layer (SSL) certificate for the custom domain for your user pool. You can use this operation to provide the Amazon Resource Name (ARN) of a new certificate to Amazon Cognito. You cannot use it to change the domain for a user pool. A custom domain is used to host the Amazon Cognito hosted UI, which provides sign-up and sign-in pages for your application. When you set up a custom domain, you provide a certificate that you manage with Certificate Manager (ACM). When necessary, you can use this operation to change the certificate that you applied to your custom domain. Usually, this is unnecessary following routine certificate renewal with ACM. When you renew your existing certificate in ACM, the ARN for your certificate remains the same, and your custom domain uses the new certificate automatically. However, if you replace your existing certificate with a new one, ACM gives the new certificate a new ARN. To apply the new certificate to your custom domain, you must provide this ARN to Amazon Cognito. When you add your new certificate in ACM, you must choose US East (N. Virginia) as the Region. After you submit your request, Amazon Cognito requires up to 1 hour to distribute your new certificate to your custom domain. For more information about adding a custom domain to your user pool, see Using Your Own Domain for the Hosted UI.

    Args:
        domain(str): The domain name for the custom domain that hosts the sign-up and sign-in pages for your application. For example: auth.example.com.  This string can include only lowercase letters, numbers, and hyphens. Do not use a hyphen for the first or last character. Use periods to separate subdomain names.
        user_pool_id(str): The ID of the user pool that is associated with the custom domain that you are updating the certificate for.
        custom_domain_config(Dict): The configuration for a custom domain that hosts the sign-up and sign-in pages for your application. Use this object to specify an SSL certificate that is managed by ACM.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.user.pool.domain.update(
                ctx, domain=value, user_pool_id=value, custom_domain_config=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.user.pool.domain.update domain=value, user_pool_id=value, custom_domain_config=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="update_user_pool_domain",
        op_kwargs={
            "Domain": domain,
            "UserPoolId": user_pool_id,
            "CustomDomainConfig": custom_domain_config,
        },
    )
