"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"set_": "set"}


async def set_(
    hub,
    ctx,
    access_token: str,
    sms_mfa_settings: Dict = None,
    software_token_mfa_settings: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Set the user's multi-factor authentication (MFA) method preference, including which MFA factors are enabled and if any are preferred. Only one factor can be set as preferred. The preferred MFA factor will be used to authenticate a user if multiple factors are enabled. If multiple options are enabled and no preference is set, a challenge to choose an MFA option will be returned during sign in. If an MFA type is enabled for a user, the user will be prompted for MFA during all sign in attempts, unless device tracking is turned on and the device has been trusted. If you would like MFA to be applied selectively based on the assessed risk level of sign in attempts, disable MFA for users and turn on Adaptive Authentication for the user pool.

    Args:
        sms_mfa_settings(Dict, optional): The SMS text message multi-factor authentication (MFA) settings. Defaults to None.
        software_token_mfa_settings(Dict, optional): The time-based one-time password software token MFA settings. Defaults to None.
        access_token(str): The access token for the user.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.user.mfa_preference.set(ctx, access_token=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.user.mfa_preference.set access_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="set_user_mfa_preference",
        op_kwargs={
            "SMSMfaSettings": sms_mfa_settings,
            "SoftwareTokenMfaSettings": software_token_mfa_settings,
            "AccessToken": access_token,
        },
    )
