"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, access_token: str) -> None:
    r"""
    **Autogenerated function**

    Allows a user to delete himself or herself.

    Args:
        access_token(str): The access token from a request to delete a user.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.user.init.delete(ctx, access_token=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.user.init.delete access_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="delete_user",
        op_kwargs={"AccessToken": access_token},
    )


async def get(hub, ctx, access_token: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the user attributes and metadata for a user.

    Args:
        access_token(str): The access token returned by the server response to get information about the user.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.user.init.get(ctx, access_token=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.user.init.get access_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="get_user",
        op_kwargs={"AccessToken": access_token},
    )


async def list_all(
    hub,
    ctx,
    user_pool_id: str,
    attributes_to_get: List = None,
    limit: int = None,
    pagination_token: str = None,
    filter_: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the users in the Amazon Cognito user pool.

    Args:
        user_pool_id(str): The user pool ID for the user pool on which the search should be performed.
        attributes_to_get(List, optional): An array of strings, where each string is the name of a user attribute to be returned for each user in the search results. If the array is null, all attributes are returned. Defaults to None.
        limit(int, optional): Maximum number of users to be returned. Defaults to None.
        pagination_token(str, optional): An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list. Defaults to None.
        filter_(str, optional): A filter string of the form "AttributeName Filter-Type "AttributeValue"". Quotation marks within the filter string must be escaped using the backslash (\) character. For example, "family_name = \"Reddy\"".    AttributeName: The name of the attribute to search for. You can only search for one attribute at a time.    Filter-Type: For an exact match, use =, for example, "given_name = \"Jon\"". For a prefix ("starts with") match, use ^=, for example, "given_name ^= \"Jon\"".     AttributeValue: The attribute value that must be matched for each user.   If the filter string is empty, ListUsers returns all users in the user pool. You can only search for the following standard attributes:    username (case-sensitive)    email     phone_number     name     given_name     family_name     preferred_username     cognito:user_status (called Status in the Console) (case-insensitive)    status (called Enabled in the Console) (case-sensitive)     sub    Custom attributes are not searchable. For more information, see Searching for Users Using the ListUsers API and Examples of Using the ListUsers API in the Amazon Cognito Developer Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.user.init.list_all(ctx, user_pool_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.user.init.list_all user_pool_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="list_users",
        op_kwargs={
            "UserPoolId": user_pool_id,
            "AttributesToGet": attributes_to_get,
            "Limit": limit,
            "PaginationToken": pagination_token,
            "Filter": filter_,
        },
    )
