"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, job_name: str, user_pool_id: str, cloud_watch_logs_role_arn: str
) -> Dict:
    r"""
    **Autogenerated function**

    Creates the user import job.

    Args:
        job_name(str): The job name for the user import job.
        user_pool_id(str): The user pool ID for the user pool that the users are being imported into.
        cloud_watch_logs_role_arn(str): The role ARN for the Amazon CloudWatch Logging role for the user import job.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.user.import_job.create(
                ctx, job_name=value, user_pool_id=value, cloud_watch_logs_role_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.user.import_job.create job_name=value, user_pool_id=value, cloud_watch_logs_role_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="create_user_import_job",
        op_kwargs={
            "JobName": job_name,
            "UserPoolId": user_pool_id,
            "CloudWatchLogsRoleArn": cloud_watch_logs_role_arn,
        },
    )


async def describe(hub, ctx, user_pool_id: str, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the user import job.

    Args:
        user_pool_id(str): The user pool ID for the user pool that the users are being imported into.
        job_id(str): The job ID for the user import job.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.user.import_job.describe(
                ctx, user_pool_id=value, job_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.user.import_job.describe user_pool_id=value, job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="describe_user_import_job",
        op_kwargs={"UserPoolId": user_pool_id, "JobId": job_id},
    )


async def list_all(
    hub, ctx, user_pool_id: str, max_results: int, pagination_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the user import jobs.

    Args:
        user_pool_id(str): The user pool ID for the user pool that the users are being imported into.
        max_results(int): The maximum number of import jobs you want the request to return.
        pagination_token(str, optional): An identifier that was returned from the previous call to ListUserImportJobs, which can be used to return the next set of import jobs in the list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.user.import_job.list_all(
                ctx, user_pool_id=value, max_results=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.user.import_job.list_all user_pool_id=value, max_results=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="list_user_import_jobs",
        op_kwargs={
            "UserPoolId": user_pool_id,
            "MaxResults": max_results,
            "PaginationToken": pagination_token,
        },
    )


async def start(hub, ctx, user_pool_id: str, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Starts the user import.

    Args:
        user_pool_id(str): The user pool ID for the user pool that the users are being imported into.
        job_id(str): The job ID for the user import job.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.user.import_job.start(
                ctx, user_pool_id=value, job_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.user.import_job.start user_pool_id=value, job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="start_user_import_job",
        op_kwargs={"UserPoolId": user_pool_id, "JobId": job_id},
    )


async def stop(hub, ctx, user_pool_id: str, job_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops the user import job.

    Args:
        user_pool_id(str): The user pool ID for the user pool that the users are being imported into.
        job_id(str): The job ID for the user import job.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.user.import_job.stop(
                ctx, user_pool_id=value, job_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.user.import_job.stop user_pool_id=value, job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="stop_user_import_job",
        op_kwargs={"UserPoolId": user_pool_id, "JobId": job_id},
    )
