"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete_multiple(
    hub, ctx, user_attribute_names: List, access_token: str
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the attributes for a user.

    Args:
        user_attribute_names(List): An array of strings representing the user attribute names you wish to delete. For custom attributes, you must prepend the custom: prefix to the attribute name.
        access_token(str): The access token used in the request to delete user attributes.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.user.attribute.init.delete_multiple(
                ctx, user_attribute_names=value, access_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.user.attribute.init.delete_multiple user_attribute_names=value, access_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="delete_user_attributes",
        op_kwargs={
            "UserAttributeNames": user_attribute_names,
            "AccessToken": access_token,
        },
    )


async def update_multiple(
    hub, ctx, user_attributes: List, access_token: str, client_metadata: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Allows a user to update a specific attribute (one at a time).  This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with Amazon Pinpoint. Cognito will use the the registered number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in. If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon SNS might place your account in SMS sandbox. In  sandbox mode , you’ll have limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see  SMS message settings for Cognito User Pools in the Amazon Cognito Developer Guide.

    Args:
        user_attributes(List): An array of name-value pairs representing user attributes. For custom attributes, you must prepend the custom: prefix to the attribute name.
        access_token(str): The access token for the request to update user attributes.
        client_metadata(Dict, optional): A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.  You create custom workflows by assigning Lambda functions to user pool triggers. When you use the UpdateUserAttributes API action, Amazon Cognito invokes the function that is assigned to the custom message trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a clientMetadata attribute, which provides the data that you assigned to the ClientMetadata parameter in your UpdateUserAttributes request. In your function code in Lambda, you can process the clientMetadata value to enhance your workflow for your specific needs. For more information, see Customizing User Pool Workflows with Lambda Triggers in the Amazon Cognito Developer Guide.  Take the following limitations into consideration when you use the ClientMetadata parameter:   Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.   Amazon Cognito does not validate the ClientMetadata value.   Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.   . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.user.attribute.init.update_multiple(
                ctx, user_attributes=value, access_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.user.attribute.init.update_multiple user_attributes=value, access_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="update_user_attributes",
        op_kwargs={
            "UserAttributes": user_attributes,
            "AccessToken": access_token,
            "ClientMetadata": client_metadata,
        },
    )


async def verify(hub, ctx, access_token: str, attribute_name: str, code: str) -> Dict:
    r"""
    **Autogenerated function**

    Verifies the specified user attributes in the user pool.

    Args:
        access_token(str): Represents the access token of the request to verify user attributes.
        attribute_name(str): The attribute name in the request to verify user attributes.
        code(str): The verification code in the request to verify user attributes.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.user.attribute.init.verify(
                ctx, access_token=value, attribute_name=value, code=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.user.attribute.init.verify access_token=value, attribute_name=value, code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="verify_user_attribute",
        op_kwargs={
            "AccessToken": access_token,
            "AttributeName": attribute_name,
            "Code": code,
        },
    )
