"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def admin(
    hub,
    ctx,
    user_pool_id: str,
    username: str,
    device_key: str,
    device_remembered_status: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the device status as an administrator. Calling this action requires developer credentials.

    Args:
        user_pool_id(str): The user pool ID.
        username(str): The user name.
        device_key(str): The device key.
        device_remembered_status(str, optional): The status indicating whether a device has been remembered or not. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.update.device_status.admin(
                ctx, user_pool_id=value, username=value, device_key=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.update.device_status.admin user_pool_id=value, username=value, device_key=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="admin_update_device_status",
        op_kwargs={
            "UserPoolId": user_pool_id,
            "Username": username,
            "DeviceKey": device_key,
            "DeviceRememberedStatus": device_remembered_status,
        },
    )
