"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def admin(
    hub, ctx, user_pool_id: str, username: str, event_id: str, feedback_value: str
) -> Dict:
    r"""
    **Autogenerated function**

    Provides feedback for an authentication event as to whether it was from a valid user. This feedback is used for improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.

    Args:
        user_pool_id(str): The user pool ID.
        username(str): The user pool username.
        event_id(str): The authentication event ID.
        feedback_value(str): The authentication event feedback value.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.update.auth_event_feedback.admin(
                ctx, user_pool_id=value, username=value, event_id=value, feedback_value=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.update.auth_event_feedback.admin user_pool_id=value, username=value, event_id=value, feedback_value=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="admin_update_auth_event_feedback",
        op_kwargs={
            "UserPoolId": user_pool_id,
            "Username": username,
            "EventId": event_id,
            "FeedbackValue": feedback_value,
        },
    )
