"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def sign(
    hub,
    ctx,
    client_id: str,
    username: str,
    password: str,
    secret_hash: str = None,
    user_attributes: List = None,
    validation_data: List = None,
    analytics_metadata: Dict = None,
    user_context_data: Dict = None,
    client_metadata: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Registers the user in the specified user pool and creates a user name, password, and user attributes.  This action might generate an SMS text message. Starting June 1, 2021, U.S. telecom carriers require that you register an origination phone number before you can send SMS messages to U.S. phone numbers. If you use SMS text messages in Amazon Cognito, you must register a phone number with Amazon Pinpoint. Cognito will use the the registered number automatically. Otherwise, Cognito users that must receive SMS messages might be unable to sign up, activate their accounts, or sign in. If you have never used SMS text messages with Amazon Cognito or any other Amazon Web Service, Amazon SNS might place your account in SMS sandbox. In  sandbox mode , you’ll have limitations, such as sending messages to only verified phone numbers. After testing in the sandbox environment, you can move out of the SMS sandbox and into production. For more information, see  SMS message settings for Cognito User Pools in the Amazon Cognito Developer Guide.

    Args:
        client_id(str): The ID of the client associated with the user pool.
        secret_hash(str, optional): A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message. Defaults to None.
        username(str): The user name of the user you wish to register.
        password(str): The password of the user you wish to register.
        user_attributes(List, optional): An array of name-value pairs representing user attributes. For custom attributes, you must prepend the custom: prefix to the attribute name. Defaults to None.
        validation_data(List, optional): The validation data in the request to register a user. Defaults to None.
        analytics_metadata(Dict, optional): The Amazon Pinpoint analytics metadata for collecting metrics for SignUp calls. Defaults to None.
        user_context_data(Dict, optional): Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security. Defaults to None.
        client_metadata(Dict, optional): A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.  You create custom workflows by assigning Lambda functions to user pool triggers. When you use the SignUp API action, Amazon Cognito invokes any functions that are assigned to the following triggers: pre sign-up, custom message, and post confirmation. When Amazon Cognito invokes any of these functions, it passes a JSON payload, which the function receives as input. This payload contains a clientMetadata attribute, which provides the data that you assigned to the ClientMetadata parameter in your SignUp request. In your function code in Lambda, you can process the clientMetadata value to enhance your workflow for your specific needs. For more information, see Customizing User Pool Workflows with Lambda Triggers in the Amazon Cognito Developer Guide.  Take the following limitations into consideration when you use the ClientMetadata parameter:   Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.   Amazon Cognito does not validate the ClientMetadata value.   Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.   . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.up.sign(
                ctx, client_id=value, username=value, password=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.up.sign client_id=value, username=value, password=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="sign_up",
        op_kwargs={
            "ClientId": client_id,
            "SecretHash": secret_hash,
            "Username": username,
            "Password": password,
            "UserAttributes": user_attributes,
            "ValidationData": validation_data,
            "AnalyticsMetadata": analytics_metadata,
            "UserContextData": user_context_data,
            "ClientMetadata": client_metadata,
        },
    )
