"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"set_": "set"}


async def get(hub, ctx, user_pool_id: str, client_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets the UI Customization information for a particular app client's app UI, if there is something set. If nothing is set for the particular client, but there is an existing pool level customization (app clientId will be ALL), then that is returned. If nothing is present, then an empty shape is returned.

    Args:
        user_pool_id(str): The user pool ID for the user pool.
        client_id(str, optional): The client ID for the client app. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.ui_customization.get(ctx, user_pool_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.ui_customization.get user_pool_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="get_ui_customization",
        op_kwargs={"UserPoolId": user_pool_id, "ClientId": client_id},
    )


async def set_(
    hub,
    ctx,
    user_pool_id: str,
    client_id: str = None,
    css: str = None,
    image_file: bytes = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Sets the UI customization information for a user pool's built-in app UI. You can specify app UI customization settings for a single client (with a specific clientId) or for all clients (by setting the clientId to ALL). If you specify ALL, the default configuration will be used for every client that has no UI customization set previously. If you specify UI customization settings for a particular client, it will no longer fall back to the ALL configuration.   To use this API, your user pool must have a domain associated with it. Otherwise, there is no place to host the app's pages, and the service will throw an error.

    Args:
        user_pool_id(str): The user pool ID for the user pool.
        client_id(str, optional): The client ID for the client app. Defaults to None.
        css(str, optional): The CSS values in the UI customization. Defaults to None.
        image_file(bytes, optional): The uploaded logo image for the UI customization. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.ui_customization.set(ctx, user_pool_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.ui_customization.set user_pool_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="set_ui_customization",
        op_kwargs={
            "UserPoolId": user_pool_id,
            "ClientId": client_id,
            "CSS": css,
            "ImageFile": image_file,
        },
    )
