"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def revoke(
    hub, ctx, token: str, client_id: str, client_secret: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Revokes all of the access tokens generated by the specified refresh token. After the token is revoked, you can not use the revoked token to access Cognito authenticated APIs.

    Args:
        token(str): The token that you want to revoke.
        client_id(str): The client ID for the token that you want to revoke.
        client_secret(str, optional): The secret for the client ID. This is required only if the client ID has a secret. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.token.revoke(ctx, token=value, client_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.token.revoke token=value, client_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="revoke_token",
        op_kwargs={
            "Token": token,
            "ClientId": client_id,
            "ClientSecret": client_secret,
        },
    )
