"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(hub, ctx, access_token: str = None, session: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a unique generated shared secret key code for the user account. The request takes an access token or a session string, but not both.  Calling AssociateSoftwareToken immediately disassociates the existing software token from the user account. If the user doesn't subsequently verify the software token, their account is essentially set up to authenticate without MFA. If MFA config is set to Optional at the user pool level, the user can then login without MFA. However, if MFA is set to Required for the user pool, the user will be asked to setup a new software token MFA during sign in.

    Args:
        access_token(str, optional): The access token. Defaults to None.
        session(str, optional): The session which should be passed both ways in challenge-response calls to the service. This allows authentication of the user as part of the MFA setup process. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.software_token.associate(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.software_token.associate
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="associate_software_token",
        op_kwargs={"AccessToken": access_token, "Session": session},
    )


async def verify(
    hub,
    ctx,
    user_code: str,
    access_token: str = None,
    session: str = None,
    friendly_device_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Use this API to register a user's entered TOTP code and mark the user's software token MFA status as "verified" if successful. The request takes an access token or a session string, but not both.

    Args:
        access_token(str, optional): The access token. Defaults to None.
        session(str, optional): The session which should be passed both ways in challenge-response calls to the service. Defaults to None.
        user_code(str): The one time password computed using the secret code returned by AssociateSoftwareToken".
        friendly_device_name(str, optional): The friendly device name. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.software_token.verify(ctx, user_code=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.software_token.verify user_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="verify_software_token",
        op_kwargs={
            "AccessToken": access_token,
            "Session": session,
            "UserCode": user_code,
            "FriendlyDeviceName": friendly_device_name,
        },
    )
