"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, user_pool_id: str) -> Dict:
    r"""
    **Autogenerated function**

    This method takes a user pool ID, and returns the signing certificate.

    Args:
        user_pool_id(str): The user pool ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.signing_certificate.get(ctx, user_pool_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.signing_certificate.get user_pool_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="get_signing_certificate",
        op_kwargs={"UserPoolId": user_pool_id},
    )
