"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def confirm(
    hub,
    ctx,
    client_id: str,
    username: str,
    confirmation_code: str,
    secret_hash: str = None,
    force_alias_creation: bool = None,
    analytics_metadata: Dict = None,
    user_context_data: Dict = None,
    client_metadata: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Confirms registration of a user and handles the existing alias from a previous user.

    Args:
        client_id(str): The ID of the app client associated with the user pool.
        secret_hash(str, optional): A keyed-hash message authentication code (HMAC) calculated using the secret key of a user pool client and username plus the client ID in the message. Defaults to None.
        username(str): The user name of the user whose registration you wish to confirm.
        confirmation_code(str): The confirmation code sent by a user's request to confirm registration.
        force_alias_creation(bool, optional): Boolean to be specified to force user confirmation irrespective of existing alias. By default set to False. If this parameter is set to True and the phone number/email used for sign up confirmation already exists as an alias with a different user, the API call will migrate the alias from the previous user to the newly created user being confirmed. If set to False, the API will throw an AliasExistsException error. Defaults to None.
        analytics_metadata(Dict, optional): The Amazon Pinpoint analytics metadata for collecting metrics for ConfirmSignUp calls. Defaults to None.
        user_context_data(Dict, optional): Contextual data such as the user's device fingerprint, IP address, or location used for evaluating the risk of an unexpected event by Amazon Cognito advanced security. Defaults to None.
        client_metadata(Dict, optional): A map of custom key-value pairs that you can provide as input for any custom workflows that this action triggers.  You create custom workflows by assigning Lambda functions to user pool triggers. When you use the ConfirmSignUp API action, Amazon Cognito invokes the function that is assigned to the post confirmation trigger. When Amazon Cognito invokes this function, it passes a JSON payload, which the function receives as input. This payload contains a clientMetadata attribute, which provides the data that you assigned to the ClientMetadata parameter in your ConfirmSignUp request. In your function code in Lambda, you can process the clientMetadata value to enhance your workflow for your specific needs. For more information, see Customizing User Pool Workflows with Lambda Triggers in the Amazon Cognito Developer Guide.  Take the following limitations into consideration when you use the ClientMetadata parameter:   Amazon Cognito does not store the ClientMetadata value. This data is available only to Lambda triggers that are assigned to a user pool to support custom workflows. If your user pool configuration does not include triggers, the ClientMetadata parameter serves no purpose.   Amazon Cognito does not validate the ClientMetadata value.   Amazon Cognito does not encrypt the the ClientMetadata value, so don't use it to provide sensitive information.   . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.sign.up.confirm(
                ctx, client_id=value, username=value, confirmation_code=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.sign.up.confirm client_id=value, username=value, confirmation_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="confirm_sign_up",
        op_kwargs={
            "ClientId": client_id,
            "SecretHash": secret_hash,
            "Username": username,
            "ConfirmationCode": confirmation_code,
            "ForceAliasCreation": force_alias_creation,
            "AnalyticsMetadata": analytics_metadata,
            "UserContextData": user_context_data,
            "ClientMetadata": client_metadata,
        },
    )
