"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"global_": "global"}


async def global_(hub, ctx, access_token: str) -> Dict:
    r"""
    **Autogenerated function**

    Signs out users from all devices. It also invalidates all refresh tokens issued to a user. The user's current access and Id tokens remain valid until their expiry. Access and Id tokens expire one hour after they are issued.

    Args:
        access_token(str): The access token.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.sign.out.global(ctx, access_token=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.sign.out.global access_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="global_sign_out",
        op_kwargs={"AccessToken": access_token},
    )
