"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def admin(hub, ctx, user_pool_id: str, username: str, mfa_options: List) -> Dict:
    r"""
    **Autogenerated function**

     This action is no longer supported. You can use it to configure only SMS MFA. You can't use it to configure TOTP software token MFA. To configure either type of MFA, use AdminSetUserMFAPreference instead.

    Args:
        user_pool_id(str): The ID of the user pool that contains the user that you are setting options for.
        username(str): The user name of the user that you are setting options for.
        mfa_options(List): You can use this parameter only to set an SMS configuration that uses SMS for delivery.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.set_user.setting.admin(
                ctx, user_pool_id=value, username=value, mfa_options=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.set_user.setting.admin user_pool_id=value, username=value, mfa_options=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="admin_set_user_settings",
        op_kwargs={
            "UserPoolId": user_pool_id,
            "Username": username,
            "MFAOptions": mfa_options,
        },
    )
