"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def admin(
    hub, ctx, user_pool_id: str, username: str, password: str, permanent: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Sets the specified user's password in a user pool as an administrator. Works on any user.  The password can be temporary or permanent. If it is temporary, the user status will be placed into the FORCE_CHANGE_PASSWORD state. When the user next tries to sign in, the InitiateAuth/AdminInitiateAuth response will contain the NEW_PASSWORD_REQUIRED challenge. If the user does not sign in before it expires, the user will not be able to sign in and their password will need to be reset by an administrator.  Once the user has set a new password, or the password is permanent, the user status will be set to Confirmed.

    Args:
        user_pool_id(str): The user pool ID for the user pool where you want to set the user's password.
        username(str): The user name of the user whose password you wish to set.
        password(str): The password for the user.
        permanent(bool, optional):  True if the password is permanent, False if it is temporary. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.set_user.password.admin(
                ctx, user_pool_id=value, username=value, password=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.set_user.password.admin user_pool_id=value, username=value, password=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="admin_set_user_password",
        op_kwargs={
            "UserPoolId": user_pool_id,
            "Username": username,
            "Password": password,
            "Permanent": permanent,
        },
    )
