"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def admin(
    hub,
    ctx,
    username: str,
    user_pool_id: str,
    sms_mfa_settings: Dict = None,
    software_token_mfa_settings: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Sets the user's multi-factor authentication (MFA) preference, including which MFA options are enabled and if any are preferred. Only one factor can be set as preferred. The preferred MFA factor will be used to authenticate a user if multiple factors are enabled. If multiple options are enabled and no preference is set, a challenge to choose an MFA option will be returned during sign in.

    Args:
        sms_mfa_settings(Dict, optional): The SMS text message MFA settings. Defaults to None.
        software_token_mfa_settings(Dict, optional): The time-based one-time password software token MFA settings. Defaults to None.
        username(str): The user pool username or alias.
        user_pool_id(str): The user pool ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.set_user.mfa_preference.admin(
                ctx, username=value, user_pool_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.set_user.mfa_preference.admin username=value, user_pool_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="admin_set_user_mfa_preference",
        op_kwargs={
            "SMSMfaSettings": sms_mfa_settings,
            "SoftwareTokenMfaSettings": software_token_mfa_settings,
            "Username": username,
            "UserPoolId": user_pool_id,
        },
    )
