"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"set_": "set"}


async def describe(hub, ctx, user_pool_id: str, client_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Describes the risk configuration.

    Args:
        user_pool_id(str): The user pool ID.
        client_id(str, optional): The app client ID. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.risk_configuration.describe(ctx, user_pool_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.risk_configuration.describe user_pool_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="describe_risk_configuration",
        op_kwargs={"UserPoolId": user_pool_id, "ClientId": client_id},
    )


async def set_(
    hub,
    ctx,
    user_pool_id: str,
    client_id: str = None,
    compromised_credentials_risk_configuration: Dict = None,
    account_takeover_risk_configuration: Dict = None,
    risk_exception_configuration: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Configures actions on detected risks. To delete the risk configuration for UserPoolId or ClientId, pass null values for all four configuration types. To enable Amazon Cognito advanced security features, update the user pool to include the UserPoolAddOns keyAdvancedSecurityMode.

    Args:
        user_pool_id(str): The user pool ID. .
        client_id(str, optional): The app client ID. If ClientId is null, then the risk configuration is mapped to userPoolId. When the client ID is null, the same risk configuration is applied to all the clients in the userPool. Otherwise, ClientId is mapped to the client. When the client ID is not null, the user pool configuration is overridden and the risk configuration for the client is used instead. Defaults to None.
        compromised_credentials_risk_configuration(Dict, optional): The compromised credentials risk configuration. Defaults to None.
        account_takeover_risk_configuration(Dict, optional): The account takeover risk configuration. Defaults to None.
        risk_exception_configuration(Dict, optional): The configuration to override the risk decision. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.risk_configuration.set(ctx, user_pool_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.risk_configuration.set user_pool_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="set_risk_configuration",
        op_kwargs={
            "UserPoolId": user_pool_id,
            "ClientId": client_id,
            "CompromisedCredentialsRiskConfiguration": compromised_credentials_risk_configuration,
            "AccountTakeoverRiskConfiguration": account_takeover_risk_configuration,
            "RiskExceptionConfiguration": risk_exception_configuration,
        },
    )
