"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def admin(
    hub,
    ctx,
    username: str,
    user_pool_id: str,
    limit: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the groups that the user belongs to. Calling this action requires developer credentials.

    Args:
        username(str): The username for the user.
        user_pool_id(str): The user pool ID for the user pool.
        limit(int, optional): The limit of the request to list groups. Defaults to None.
        next_token(str, optional): An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.list_.group_for_user.admin(
                ctx, username=value, user_pool_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.list_.group_for_user.admin username=value, user_pool_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="admin_list_groups_for_user",
        op_kwargs={
            "Username": username,
            "UserPoolId": user_pool_id,
            "Limit": limit,
            "NextToken": next_token,
        },
    )
