"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def admin(
    hub,
    ctx,
    user_pool_id: str,
    username: str,
    limit: int = None,
    pagination_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists devices, as an administrator. Calling this action requires developer credentials.

    Args:
        user_pool_id(str): The user pool ID.
        username(str): The user name.
        limit(int, optional): The limit of the devices request. Defaults to None.
        pagination_token(str, optional): The pagination token. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.list_.device.admin(
                ctx, user_pool_id=value, username=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.list_.device.admin user_pool_id=value, username=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="admin_list_devices",
        op_kwargs={
            "UserPoolId": user_pool_id,
            "Username": username,
            "Limit": limit,
            "PaginationToken": pagination_token,
        },
    )
