"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    user_pool_id: str,
    provider_name: str,
    provider_type: str,
    provider_details: Dict,
    attribute_mapping: Dict = None,
    idp_identifiers: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an identity provider for a user pool.

    Args:
        user_pool_id(str): The user pool ID.
        provider_name(str): The identity provider name.
        provider_type(str): The identity provider type.
        provider_details(Dict): The identity provider details. The following list describes the provider detail keys for each identity provider type.   For Google and Login with Amazon:   client_id   client_secret   authorize_scopes     For Facebook:   client_id   client_secret   authorize_scopes   api_version     For Sign in with Apple:   client_id   team_id   key_id   private_key   authorize_scopes     For OIDC providers:   client_id   client_secret   attributes_request_method   oidc_issuer   authorize_scopes   authorize_url if not available from discovery URL specified by oidc_issuer key    token_url if not available from discovery URL specified by oidc_issuer key    attributes_url if not available from discovery URL specified by oidc_issuer key    jwks_uri if not available from discovery URL specified by oidc_issuer key      For SAML providers:   MetadataFile OR MetadataURL   IDPSignout optional     .
        attribute_mapping(Dict, optional): A mapping of identity provider attributes to standard and custom user pool attributes. Defaults to None.
        idp_identifiers(List, optional): A list of identity provider identifiers. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.identity_provider.init.create(
                ctx,
                user_pool_id=value,
                provider_name=value,
                provider_type=value,
                provider_details=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.identity_provider.init.create user_pool_id=value, provider_name=value, provider_type=value, provider_details=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="create_identity_provider",
        op_kwargs={
            "UserPoolId": user_pool_id,
            "ProviderName": provider_name,
            "ProviderType": provider_type,
            "ProviderDetails": provider_details,
            "AttributeMapping": attribute_mapping,
            "IdpIdentifiers": idp_identifiers,
        },
    )


async def delete(hub, ctx, user_pool_id: str, provider_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes an identity provider for a user pool.

    Args:
        user_pool_id(str): The user pool ID.
        provider_name(str): The identity provider name.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.identity_provider.init.delete(
                ctx, user_pool_id=value, provider_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.identity_provider.init.delete user_pool_id=value, provider_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="delete_identity_provider",
        op_kwargs={"UserPoolId": user_pool_id, "ProviderName": provider_name},
    )


async def describe(hub, ctx, user_pool_id: str, provider_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a specific identity provider.

    Args:
        user_pool_id(str): The user pool ID.
        provider_name(str): The identity provider name.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.identity_provider.init.describe(
                ctx, user_pool_id=value, provider_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.identity_provider.init.describe user_pool_id=value, provider_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="describe_identity_provider",
        op_kwargs={"UserPoolId": user_pool_id, "ProviderName": provider_name},
    )


async def list_all(
    hub, ctx, user_pool_id: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists information about all identity providers for a user pool.

    Args:
        user_pool_id(str): The user pool ID.
        max_results(int, optional): The maximum number of identity providers to return. Defaults to None.
        next_token(str, optional): A pagination token. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.identity_provider.init.list_all(
                ctx, user_pool_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.identity_provider.init.list_all user_pool_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="list_identity_providers",
        op_kwargs={
            "UserPoolId": user_pool_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    user_pool_id: str,
    provider_name: str,
    provider_details: Dict = None,
    attribute_mapping: Dict = None,
    idp_identifiers: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates identity provider information for a user pool.

    Args:
        user_pool_id(str): The user pool ID.
        provider_name(str): The identity provider name.
        provider_details(Dict, optional): The identity provider details to be updated, such as MetadataURL and MetadataFile. Defaults to None.
        attribute_mapping(Dict, optional): The identity provider attribute mapping to be changed. Defaults to None.
        idp_identifiers(List, optional): A list of identity provider identifiers. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.identity_provider.init.update(
                ctx, user_pool_id=value, provider_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.identity_provider.init.update user_pool_id=value, provider_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="update_identity_provider",
        op_kwargs={
            "UserPoolId": user_pool_id,
            "ProviderName": provider_name,
            "ProviderDetails": provider_details,
            "AttributeMapping": attribute_mapping,
            "IdpIdentifiers": idp_identifiers,
        },
    )
