"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, user_pool_id: str, idp_identifier: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the specified identity provider.

    Args:
        user_pool_id(str): The user pool ID.
        idp_identifier(str): The identity provider ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.identity_provider.by_identifier.get(
                ctx, user_pool_id=value, idp_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.identity_provider.by_identifier.get user_pool_id=value, idp_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="get_identity_provider_by_identifier",
        op_kwargs={"UserPoolId": user_pool_id, "IdpIdentifier": idp_identifier},
    )
