"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    group_name: str,
    user_pool_id: str,
    description: str = None,
    role_arn: str = None,
    precedence: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new group in the specified user pool. Calling this action requires developer credentials.

    Args:
        group_name(str): The name of the group. Must be unique.
        user_pool_id(str): The user pool ID for the user pool.
        description(str, optional): A string containing the description of the group. Defaults to None.
        role_arn(str, optional): The role ARN for the group. Defaults to None.
        precedence(int, optional): A nonnegative integer value that specifies the precedence of this group relative to the other groups that a user can belong to in the user pool. Zero is the highest precedence value. Groups with lower Precedence values take precedence over groups with higher or null Precedence values. If a user belongs to two or more groups, it is the group with the lowest precedence value whose role ARN will be used in the cognito:roles and cognito:preferred_role claims in the user's tokens. Two groups can have the same Precedence value. If this happens, neither group takes precedence over the other. If two groups with the same Precedence have the same role ARN, that role is used in the cognito:preferred_role claim in tokens for users in each group. If the two groups have different role ARNs, the cognito:preferred_role claim is not set in users' tokens. The default Precedence value is null. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.group.create(
                ctx, group_name=value, user_pool_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.group.create group_name=value, user_pool_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="create_group",
        op_kwargs={
            "GroupName": group_name,
            "UserPoolId": user_pool_id,
            "Description": description,
            "RoleArn": role_arn,
            "Precedence": precedence,
        },
    )


async def delete(hub, ctx, group_name: str, user_pool_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a group. Calling this action requires developer credentials.

    Args:
        group_name(str): The name of the group.
        user_pool_id(str): The user pool ID for the user pool.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.group.delete(
                ctx, group_name=value, user_pool_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.group.delete group_name=value, user_pool_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="delete_group",
        op_kwargs={"GroupName": group_name, "UserPoolId": user_pool_id},
    )


async def get(hub, ctx, group_name: str, user_pool_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets a group. Calling this action requires developer credentials.

    Args:
        group_name(str): The name of the group.
        user_pool_id(str): The user pool ID for the user pool.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.group.get(ctx, group_name=value, user_pool_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.group.get group_name=value, user_pool_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="get_group",
        op_kwargs={"GroupName": group_name, "UserPoolId": user_pool_id},
    )


async def list_all(
    hub, ctx, user_pool_id: str, limit: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the groups associated with a user pool. Calling this action requires developer credentials.

    Args:
        user_pool_id(str): The user pool ID for the user pool.
        limit(int, optional): The limit of the request to list groups. Defaults to None.
        next_token(str, optional): An identifier that was returned from the previous call to this operation, which can be used to return the next set of items in the list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.group.list_all(ctx, user_pool_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.group.list_all user_pool_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="list_groups",
        op_kwargs={"UserPoolId": user_pool_id, "Limit": limit, "NextToken": next_token},
    )


async def update(
    hub,
    ctx,
    group_name: str,
    user_pool_id: str,
    description: str = None,
    role_arn: str = None,
    precedence: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified group with the specified attributes. Calling this action requires developer credentials.

    Args:
        group_name(str): The name of the group.
        user_pool_id(str): The user pool ID for the user pool.
        description(str, optional): A string containing the new description of the group. Defaults to None.
        role_arn(str, optional): The new role ARN for the group. This is used for setting the cognito:roles and cognito:preferred_role claims in the token. Defaults to None.
        precedence(int, optional): The new precedence value for the group. For more information about this parameter, see CreateGroup. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.group.update(
                ctx, group_name=value, user_pool_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.group.update group_name=value, user_pool_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="update_group",
        op_kwargs={
            "GroupName": group_name,
            "UserPoolId": user_pool_id,
            "Description": description,
            "RoleArn": role_arn,
            "Precedence": precedence,
        },
    )
