"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def admin(hub, ctx, device_key: str, user_pool_id: str, username: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the device, as an administrator. Calling this action requires developer credentials.

    Args:
        device_key(str): The device key.
        user_pool_id(str): The user pool ID.
        username(str): The user name.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.get.device.admin(
                ctx, device_key=value, user_pool_id=value, username=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.get.device.admin device_key=value, user_pool_id=value, username=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="admin_get_device",
        op_kwargs={
            "DeviceKey": device_key,
            "UserPoolId": user_pool_id,
            "Username": username,
        },
    )
