"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def admin(hub, ctx, user_pool_id: str, username: str, device_key: str) -> None:
    r"""
    **Autogenerated function**

    Forgets the device, as an administrator. Calling this action requires developer credentials.

    Args:
        user_pool_id(str): The user pool ID.
        username(str): The user name.
        device_key(str): The device key.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.forget_device.admin(
                ctx, user_pool_id=value, username=value, device_key=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.forget_device.admin user_pool_id=value, username=value, device_key=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="admin_forget_device",
        op_kwargs={
            "UserPoolId": user_pool_id,
            "Username": username,
            "DeviceKey": device_key,
        },
    )
