"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub, ctx, access_token: str, device_key: str, device_remembered_status: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the device status.

    Args:
        access_token(str): The access token.
        device_key(str): The device key.
        device_remembered_status(str, optional): The status of whether a device is remembered. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.device.status.update(
                ctx, access_token=value, device_key=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.device.status.update access_token=value, device_key=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="update_device_status",
        op_kwargs={
            "AccessToken": access_token,
            "DeviceKey": device_key,
            "DeviceRememberedStatus": device_remembered_status,
        },
    )
