"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def confirm(
    hub,
    ctx,
    access_token: str,
    device_key: str,
    device_secret_verifier_config: Dict = None,
    device_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Confirms tracking of the device. This API call is the call that begins device tracking.

    Args:
        access_token(str): The access token.
        device_key(str): The device key.
        device_secret_verifier_config(Dict, optional): The configuration of the device secret verifier. Defaults to None.
        device_name(str, optional): The device name. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.device.init.confirm(
                ctx, access_token=value, device_key=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.device.init.confirm access_token=value, device_key=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="confirm_device",
        op_kwargs={
            "AccessToken": access_token,
            "DeviceKey": device_key,
            "DeviceSecretVerifierConfig": device_secret_verifier_config,
            "DeviceName": device_name,
        },
    )


async def forget(hub, ctx, device_key: str, access_token: str = None) -> None:
    r"""
    **Autogenerated function**

    Forgets the specified device.

    Args:
        access_token(str, optional): The access token for the forgotten device request. Defaults to None.
        device_key(str): The device key.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.device.init.forget(ctx, device_key=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.device.init.forget device_key=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="forget_device",
        op_kwargs={"AccessToken": access_token, "DeviceKey": device_key},
    )


async def get(hub, ctx, device_key: str, access_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets the device.

    Args:
        device_key(str): The device key.
        access_token(str, optional): The access token. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.device.init.get(ctx, device_key=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.device.init.get device_key=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="get_device",
        op_kwargs={"DeviceKey": device_key, "AccessToken": access_token},
    )


async def list_all(
    hub, ctx, access_token: str, limit: int = None, pagination_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the devices.

    Args:
        access_token(str): The access tokens for the request to list devices.
        limit(int, optional): The limit of the device request. Defaults to None.
        pagination_token(str, optional): The pagination token for the list request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.device.init.list_all(ctx, access_token=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.device.init.list_all access_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="list_devices",
        op_kwargs={
            "AccessToken": access_token,
            "Limit": limit,
            "PaginationToken": pagination_token,
        },
    )
