"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def admin(hub, ctx, user_pool_id: str, username: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a user as an administrator. Works on any user. Calling this action requires developer credentials.

    Args:
        user_pool_id(str): The user pool ID for the user pool where you want to delete the user.
        username(str): The user name of the user you wish to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.delete_user.init.admin(
                ctx, user_pool_id=value, username=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.delete_user.init.admin user_pool_id=value, username=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="admin_delete_user",
        op_kwargs={"UserPoolId": user_pool_id, "Username": username},
    )
