"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def admin(
    hub, ctx, user_pool_id: str, username: str, user_attribute_names: List
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the user attributes in a user pool as an administrator. Works on any user. Calling this action requires developer credentials.

    Args:
        user_pool_id(str): The user pool ID for the user pool where you want to delete user attributes.
        username(str): The user name of the user from which you would like to delete attributes.
        user_attribute_names(List): An array of strings representing the user attribute names you wish to delete. For custom attributes, you must prepend the custom: prefix to the attribute name.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.delete_user.attribute.admin(
                ctx, user_pool_id=value, username=value, user_attribute_names=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.delete_user.attribute.admin user_pool_id=value, username=value, user_attribute_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="admin_delete_user_attributes",
        op_kwargs={
            "UserPoolId": user_pool_id,
            "Username": username,
            "UserAttributeNames": user_attribute_names,
        },
    )
