"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def add(hub, ctx, user_pool_id: str, custom_attributes: List) -> Dict:
    r"""
    **Autogenerated function**

    Adds additional user attributes to the user pool schema.

    Args:
        user_pool_id(str): The user pool ID for the user pool where you want to add custom attributes.
        custom_attributes(List): An array of custom attributes, such as Mutable and Name.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.custom_attribute.add(
                ctx, user_pool_id=value, custom_attributes=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.custom_attribute.add user_pool_id=value, custom_attributes=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="add_custom_attributes",
        op_kwargs={"UserPoolId": user_pool_id, "CustomAttributes": custom_attributes},
    )
