"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, user_pool_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the header information for the .csv file to be used as input for the user import job.

    Args:
        user_pool_id(str): The user pool ID for the user pool that the users are to be imported into.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.csv_header.get(ctx, user_pool_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.csv_header.get user_pool_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="get_csv_header",
        op_kwargs={"UserPoolId": user_pool_id},
    )
