"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub,
    ctx,
    user_pool_id: str,
    username: str,
    event_id: str,
    feedback_token: str,
    feedback_value: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Provides the feedback for an authentication event whether it was from a valid user or not. This feedback is used for improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.

    Args:
        user_pool_id(str): The user pool ID.
        username(str): The user pool username.
        event_id(str): The event ID.
        feedback_token(str): The feedback token.
        feedback_value(str): The authentication event feedback value.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.auth.event_feedback.update(
                ctx,
                user_pool_id=value,
                username=value,
                event_id=value,
                feedback_token=value,
                feedback_value=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.auth.event_feedback.update user_pool_id=value, username=value, event_id=value, feedback_token=value, feedback_value=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="update_auth_event_feedback",
        op_kwargs={
            "UserPoolId": user_pool_id,
            "Username": username,
            "EventId": event_id,
            "FeedbackToken": feedback_token,
            "FeedbackValue": feedback_value,
        },
    )
