"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def admin(hub, ctx, user_pool_id: str, username: str, group_name: str) -> None:
    r"""
    **Autogenerated function**

    Adds the specified user to the specified group. Calling this action requires developer credentials.

    Args:
        user_pool_id(str): The user pool ID for the user pool.
        username(str): The username for the user.
        group_name(str): The group name.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_idp.add_user_to_group.admin(
                ctx, user_pool_id=value, username=value, group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_idp.add_user_to_group.admin user_pool_id=value, username=value, group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-idp",
        operation="admin_add_user_to_group",
        op_kwargs={
            "UserPoolId": user_pool_id,
            "Username": username,
            "GroupName": group_name,
        },
    )
