"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "principal_tag_attribute_map"


__func_alias__ = {"set_": "set"}


async def get(hub, ctx, identity_pool_id: str, identity_provider_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Use GetPrincipalTagAttributeMap to list all mappings between PrincipalTags and user attributes.

    Args:
        identity_pool_id(str): You can use this operation to get the ID of the Identity Pool you setup attribute mappings for.
        identity_provider_name(str): You can use this operation to get the provider name.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_identity.principal_tag_attribute_map_.get(
                ctx, identity_pool_id=value, identity_provider_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_identity.principal_tag_attribute_map.get identity_pool_id=value, identity_provider_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-identity",
        operation="get_principal_tag_attribute_map",
        op_kwargs={
            "IdentityPoolId": identity_pool_id,
            "IdentityProviderName": identity_provider_name,
        },
    )


async def set_(
    hub,
    ctx,
    identity_pool_id: str,
    identity_provider_name: str,
    use_defaults: bool = None,
    principal_tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    You can use this operation to use default (username and clientID) attribute or custom attribute mappings.

    Args:
        identity_pool_id(str): The ID of the Identity Pool you want to set attribute mappings for.
        identity_provider_name(str): The provider name you want to use for attribute mappings.
        use_defaults(bool, optional): You can use this operation to use default (username and clientID) attribute mappings. Defaults to None.
        principal_tags(Dict, optional): You can use this operation to add principal tags. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_identity.principal_tag_attribute_map_.set(
                ctx, identity_pool_id=value, identity_provider_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_identity.principal_tag_attribute_map.set identity_pool_id=value, identity_provider_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-identity",
        operation="set_principal_tag_attribute_map",
        op_kwargs={
            "IdentityPoolId": identity_pool_id,
            "IdentityProviderName": identity_provider_name,
            "UseDefaults": use_defaults,
            "PrincipalTags": principal_tags,
        },
    )
