"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, identity_id: str, logins: Dict = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets an OpenID token, using a known Cognito ID. This known Cognito ID is returned by GetId. You can optionally add additional logins for the identity. Supplying multiple logins creates an implicit link. The OpenID token is valid for 10 minutes. This is a public API. You do not need any credentials to call this API.

    Args:
        identity_id(str): A unique identifier in the format REGION:GUID.
        logins(Dict, optional): A set of optional name-value pairs that map provider names to provider tokens. When using graph.facebook.com and www.amazon.com, supply the access_token returned from the provider's authflow. For accounts.google.com, an Amazon Cognito user pool provider, or any other OpenID Connect provider, always include the id_token. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_identity.open_id_token.init.get(ctx, identity_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_identity.open_id_token.init.get identity_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-identity",
        operation="get_open_id_token",
        op_kwargs={"IdentityId": identity_id, "Logins": logins},
    )
