"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    identity_pool_name: str,
    allow_unauthenticated_identities: bool,
    allow_classic_flow: bool = None,
    supported_login_providers: Dict = None,
    developer_provider_name: str = None,
    open_id_connect_provider_ar_ns: List = None,
    cognito_identity_providers: List = None,
    saml_provider_ar_ns: List = None,
    identity_pool_tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new identity pool. The identity pool is a store of user identity information that is specific to your AWS account. The keys for SupportedLoginProviders are as follows:   Facebook: graph.facebook.com    Google: accounts.google.com    Amazon: www.amazon.com    Twitter: api.twitter.com    Digits: www.digits.com    You must use AWS Developer credentials to call this API.

    Args:
        identity_pool_name(str): A string that you provide.
        allow_unauthenticated_identities(bool): TRUE if the identity pool supports unauthenticated logins.
        allow_classic_flow(bool, optional): Enables or disables the Basic (Classic) authentication flow. For more information, see Identity Pools (Federated Identities) Authentication Flow in the Amazon Cognito Developer Guide. Defaults to None.
        supported_login_providers(Dict, optional): Optional key:value pairs mapping provider names to provider app IDs. Defaults to None.
        developer_provider_name(str, optional): The "domain" by which Cognito will refer to your users. This name acts as a placeholder that allows your backend and the Cognito service to communicate about the developer provider. For the DeveloperProviderName, you can use letters as well as period (.), underscore (_), and dash (-). Once you have set a developer provider name, you cannot change it. Please take care in setting this parameter. Defaults to None.
        open_id_connect_provider_ar_ns(List, optional): The Amazon Resource Names (ARN) of the OpenID Connect providers. Defaults to None.
        cognito_identity_providers(List, optional): An array of Amazon Cognito user pools and their client IDs. Defaults to None.
        saml_provider_ar_ns(List, optional): An array of Amazon Resource Names (ARNs) of the SAML provider for your identity pool. Defaults to None.
        identity_pool_tags(Dict, optional): Tags to assign to the identity pool. A tag is a label that you can apply to identity pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_identity.identity.pool.init.create(
                ctx, identity_pool_name=value, allow_unauthenticated_identities=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_identity.identity.pool.init.create identity_pool_name=value, allow_unauthenticated_identities=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-identity",
        operation="create_identity_pool",
        op_kwargs={
            "IdentityPoolName": identity_pool_name,
            "AllowUnauthenticatedIdentities": allow_unauthenticated_identities,
            "AllowClassicFlow": allow_classic_flow,
            "SupportedLoginProviders": supported_login_providers,
            "DeveloperProviderName": developer_provider_name,
            "OpenIdConnectProviderARNs": open_id_connect_provider_ar_ns,
            "CognitoIdentityProviders": cognito_identity_providers,
            "SamlProviderARNs": saml_provider_ar_ns,
            "IdentityPoolTags": identity_pool_tags,
        },
    )


async def delete(hub, ctx, identity_pool_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes an identity pool. Once a pool is deleted, users will not be able to authenticate with the pool. You must use AWS Developer credentials to call this API.

    Args:
        identity_pool_id(str): An identity pool ID in the format REGION:GUID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_identity.identity.pool.init.delete(
                ctx, identity_pool_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_identity.identity.pool.init.delete identity_pool_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-identity",
        operation="delete_identity_pool",
        op_kwargs={"IdentityPoolId": identity_pool_id},
    )


async def describe(hub, ctx, identity_pool_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets details about a particular identity pool, including the pool name, ID description, creation date, and current number of users. You must use AWS Developer credentials to call this API.

    Args:
        identity_pool_id(str): An identity pool ID in the format REGION:GUID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_identity.identity.pool.init.describe(
                ctx, identity_pool_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_identity.identity.pool.init.describe identity_pool_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-identity",
        operation="describe_identity_pool",
        op_kwargs={"IdentityPoolId": identity_pool_id},
    )


async def list_all(hub, ctx, max_results: int, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists all of the Cognito identity pools registered for your account. You must use AWS Developer credentials to call this API.

    Args:
        max_results(int): The maximum number of identities to return.
        next_token(str, optional): A pagination token. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_identity.identity.pool.init.list_all(
                ctx, max_results=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_identity.identity.pool.init.list_all max_results=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-identity",
        operation="list_identity_pools",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def update(
    hub,
    ctx,
    identity_pool_id: str,
    identity_pool_name: str,
    allow_unauthenticated_identities: bool,
    allow_classic_flow: bool = None,
    supported_login_providers: Dict = None,
    developer_provider_name: str = None,
    open_id_connect_provider_ar_ns: List = None,
    cognito_identity_providers: List = None,
    saml_provider_ar_ns: List = None,
    identity_pool_tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an identity pool. You must use AWS Developer credentials to call this API.

    Args:
        identity_pool_id(str): An identity pool ID in the format REGION:GUID.
        identity_pool_name(str): A string that you provide.
        allow_unauthenticated_identities(bool): TRUE if the identity pool supports unauthenticated logins.
        allow_classic_flow(bool, optional): Enables or disables the Basic (Classic) authentication flow. For more information, see Identity Pools (Federated Identities) Authentication Flow in the Amazon Cognito Developer Guide. Defaults to None.
        supported_login_providers(Dict, optional): Optional key:value pairs mapping provider names to provider app IDs. Defaults to None.
        developer_provider_name(str, optional): The "domain" by which Cognito will refer to your users. Defaults to None.
        open_id_connect_provider_ar_ns(List, optional): The ARNs of the OpenID Connect providers. Defaults to None.
        cognito_identity_providers(List, optional): A list representing an Amazon Cognito user pool and its client ID. Defaults to None.
        saml_provider_ar_ns(List, optional): An array of Amazon Resource Names (ARNs) of the SAML provider for your identity pool. Defaults to None.
        identity_pool_tags(Dict, optional): The tags that are assigned to the identity pool. A tag is a label that you can apply to identity pools to categorize and manage them in different ways, such as by purpose, owner, environment, or other criteria. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_identity.identity.pool.init.update(
                ctx,
                identity_pool_id=value,
                identity_pool_name=value,
                allow_unauthenticated_identities=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_identity.identity.pool.init.update identity_pool_id=value, identity_pool_name=value, allow_unauthenticated_identities=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-identity",
        operation="update_identity_pool",
        op_kwargs={
            "IdentityPoolId": identity_pool_id,
            "IdentityPoolName": identity_pool_name,
            "AllowUnauthenticatedIdentities": allow_unauthenticated_identities,
            "AllowClassicFlow": allow_classic_flow,
            "SupportedLoginProviders": supported_login_providers,
            "DeveloperProviderName": developer_provider_name,
            "OpenIdConnectProviderARNs": open_id_connect_provider_ar_ns,
            "CognitoIdentityProviders": cognito_identity_providers,
            "SamlProviderARNs": saml_provider_ar_ns,
            "IdentityPoolTags": identity_pool_tags,
        },
    )
