"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete_multiple(hub, ctx, identity_ids_to_delete: List) -> Dict:
    r"""
    **Autogenerated function**

    Deletes identities from an identity pool. You can specify a list of 1-60 identities that you want to delete. You must use AWS Developer credentials to call this API.

    Args:
        identity_ids_to_delete(List): A list of 1-60 identities that you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_identity.identity.init.delete_multiple(
                ctx, identity_ids_to_delete=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_identity.identity.init.delete_multiple identity_ids_to_delete=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-identity",
        operation="delete_identities",
        op_kwargs={"IdentityIdsToDelete": identity_ids_to_delete},
    )


async def describe(hub, ctx, identity_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns metadata related to the given identity, including when the identity was created and any associated linked logins. You must use AWS Developer credentials to call this API.

    Args:
        identity_id(str): A unique identifier in the format REGION:GUID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_identity.identity.init.describe(ctx, identity_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_identity.identity.init.describe identity_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-identity",
        operation="describe_identity",
        op_kwargs={"IdentityId": identity_id},
    )


async def list_all(
    hub,
    ctx,
    identity_pool_id: str,
    max_results: int,
    next_token: str = None,
    hide_disabled: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the identities in an identity pool. You must use AWS Developer credentials to call this API.

    Args:
        identity_pool_id(str): An identity pool ID in the format REGION:GUID.
        max_results(int): The maximum number of identities to return.
        next_token(str, optional): A pagination token. Defaults to None.
        hide_disabled(bool, optional): An optional boolean parameter that allows you to hide disabled identities. If omitted, the ListIdentities API will include disabled identities in the response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_identity.identity.init.list_all(
                ctx, identity_pool_id=value, max_results=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_identity.identity.init.list_all identity_pool_id=value, max_results=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-identity",
        operation="list_identities",
        op_kwargs={
            "IdentityPoolId": identity_pool_id,
            "MaxResults": max_results,
            "NextToken": next_token,
            "HideDisabled": hide_disabled,
        },
    )


async def unlink(
    hub, ctx, identity_id: str, logins: Dict, logins_to_remove: List
) -> None:
    r"""
    **Autogenerated function**

    Unlinks a federated identity from an existing account. Unlinked logins will be considered new identities next time they are seen. Removing the last linked login will make this identity inaccessible. This is a public API. You do not need any credentials to call this API.

    Args:
        identity_id(str): A unique identifier in the format REGION:GUID.
        logins(Dict): A set of optional name-value pairs that map provider names to provider tokens.
        logins_to_remove(List): Provider names to unlink from this identity.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_identity.identity.init.unlink(
                ctx, identity_id=value, logins=value, logins_to_remove=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_identity.identity.init.unlink identity_id=value, logins=value, logins_to_remove=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-identity",
        operation="unlink_identity",
        op_kwargs={
            "IdentityId": identity_id,
            "Logins": logins,
            "LoginsToRemove": logins_to_remove,
        },
    )
