"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "id"


async def get(
    hub, ctx, identity_pool_id: str, account_id: str = None, logins: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Generates (or retrieves) a Cognito ID. Supplying multiple logins will create an implicit linked account. This is a public API. You do not need any credentials to call this API.

    Args:
        account_id(str, optional): A standard AWS account ID (9+ digits). Defaults to None.
        identity_pool_id(str): An identity pool ID in the format REGION:GUID.
        logins(Dict, optional): A set of optional name-value pairs that map provider names to provider tokens. The available provider names for Logins are as follows:   Facebook: graph.facebook.com    Amazon Cognito user pool: cognito-idp.<region>.amazonaws.com/<YOUR_USER_POOL_ID>, for example, cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789.    Google: accounts.google.com    Amazon: www.amazon.com    Twitter: api.twitter.com    Digits: www.digits.com   . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_identity.id_.get(ctx, identity_pool_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_identity.id.get identity_pool_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-identity",
        operation="get_id",
        op_kwargs={
            "AccountId": account_id,
            "IdentityPoolId": identity_pool_id,
            "Logins": logins,
        },
    )
