"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def lookup(
    hub,
    ctx,
    identity_pool_id: str,
    identity_id: str = None,
    developer_user_identifier: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the IdentityID associated with a DeveloperUserIdentifier or the list of DeveloperUserIdentifier values associated with an IdentityId for an existing identity. Either IdentityID or DeveloperUserIdentifier must not be null. If you supply only one of these values, the other value will be searched in the database and returned as a part of the response. If you supply both, DeveloperUserIdentifier will be matched against IdentityID. If the values are verified against the database, the response returns both values and is the same as the request. Otherwise a ResourceConflictException is thrown.  LookupDeveloperIdentity is intended for low-throughput control plane operations: for example, to enable customer service to locate an identity ID by username. If you are using it for higher-volume operations such as user authentication, your requests are likely to be throttled. GetOpenIdTokenForDeveloperIdentity is a better option for higher-volume operations for user authentication. You must use AWS Developer credentials to call this API.

    Args:
        identity_pool_id(str): An identity pool ID in the format REGION:GUID.
        identity_id(str, optional): A unique identifier in the format REGION:GUID. Defaults to None.
        developer_user_identifier(str, optional): A unique ID used by your backend authentication process to identify a user. Typically, a developer identity provider would issue many developer user identifiers, in keeping with the number of users. Defaults to None.
        max_results(int, optional): The maximum number of identities to return. Defaults to None.
        next_token(str, optional): A pagination token. The first call you make will have NextToken set to null. After that the service will return NextToken values as needed. For example, let's say you make a request with MaxResults set to 10, and there are 20 matches in the database. The service will return a pagination token as a part of the response. This token can be used to call the API again and get results starting from the 11th match. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_identity.developer_identity.lookup(
                ctx, identity_pool_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_identity.developer_identity.lookup identity_pool_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-identity",
        operation="lookup_developer_identity",
        op_kwargs={
            "IdentityPoolId": identity_pool_id,
            "IdentityId": identity_id,
            "DeveloperUserIdentifier": developer_user_identifier,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def merge(
    hub,
    ctx,
    source_user_identifier: str,
    destination_user_identifier: str,
    developer_provider_name: str,
    identity_pool_id: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Merges two users having different IdentityIds, existing in the same identity pool, and identified by the same developer provider. You can use this action to request that discrete users be merged and identified as a single user in the Cognito environment. Cognito associates the given source user (SourceUserIdentifier) with the IdentityId of the DestinationUserIdentifier. Only developer-authenticated users can be merged. If the users to be merged are associated with the same public provider, but as two different users, an exception will be thrown. The number of linked logins is limited to 20. So, the number of linked logins for the source user, SourceUserIdentifier, and the destination user, DestinationUserIdentifier, together should not be larger than 20. Otherwise, an exception will be thrown. You must use AWS Developer credentials to call this API.

    Args:
        source_user_identifier(str): User identifier for the source user. The value should be a DeveloperUserIdentifier.
        destination_user_identifier(str): User identifier for the destination user. The value should be a DeveloperUserIdentifier.
        developer_provider_name(str): The "domain" by which Cognito will refer to your users. This is a (pseudo) domain name that you provide while creating an identity pool. This name acts as a placeholder that allows your backend and the Cognito service to communicate about the developer provider. For the DeveloperProviderName, you can use letters as well as period (.), underscore (_), and dash (-).
        identity_pool_id(str): An identity pool ID in the format REGION:GUID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_identity.developer_identity.merge(
                ctx,
                source_user_identifier=value,
                destination_user_identifier=value,
                developer_provider_name=value,
                identity_pool_id=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_identity.developer_identity.merge source_user_identifier=value, destination_user_identifier=value, developer_provider_name=value, identity_pool_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-identity",
        operation="merge_developer_identities",
        op_kwargs={
            "SourceUserIdentifier": source_user_identifier,
            "DestinationUserIdentifier": destination_user_identifier,
            "DeveloperProviderName": developer_provider_name,
            "IdentityPoolId": identity_pool_id,
        },
    )


async def unlink(
    hub,
    ctx,
    identity_id: str,
    identity_pool_id: str,
    developer_provider_name: str,
    developer_user_identifier: str,
) -> None:
    r"""
    **Autogenerated function**

    Unlinks a DeveloperUserIdentifier from an existing identity. Unlinked developer users will be considered new identities next time they are seen. If, for a given Cognito identity, you remove all federated identities as well as the developer user identifier, the Cognito identity becomes inaccessible. You must use AWS Developer credentials to call this API.

    Args:
        identity_id(str): A unique identifier in the format REGION:GUID.
        identity_pool_id(str): An identity pool ID in the format REGION:GUID.
        developer_provider_name(str): The "domain" by which Cognito will refer to your users.
        developer_user_identifier(str): A unique ID used by your backend authentication process to identify a user.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cognito_identity.developer_identity.unlink(
                ctx,
                identity_id=value,
                identity_pool_id=value,
                developer_provider_name=value,
                developer_user_identifier=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cognito_identity.developer_identity.unlink identity_id=value, identity_pool_id=value, developer_provider_name=value, developer_user_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cognito-identity",
        operation="unlink_developer_identity",
        op_kwargs={
            "IdentityId": identity_id,
            "IdentityPoolId": identity_pool_id,
            "DeveloperProviderName": developer_provider_name,
            "DeveloperUserIdentifier": developer_user_identifier,
        },
    )
