"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(
    hub, ctx, target_address: str, force_unsubscribe_all: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a specified target for notifications.

    Args:
        target_address(str): The Amazon Resource Name (ARN) of the SNS topic to delete.
        force_unsubscribe_all(bool, optional): A Boolean value that can be used to delete all associations with this SNS topic. The default value is FALSE. If set to TRUE, all associations between that target and every notification rule in your AWS account are deleted. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codestar_notification.target.delete(ctx, target_address=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codestar_notification.target.delete target_address=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codestar-notifications",
        operation="delete_target",
        op_kwargs={
            "TargetAddress": target_address,
            "ForceUnsubscribeAll": force_unsubscribe_all,
        },
    )


async def list_all(
    hub, ctx, filters: List = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of the notification rule targets for an AWS account.

    Args:
        filters(List, optional): The filters to use to return information by service or resource type. Valid filters include target type, target address, and target status.  A filter with the same name can appear more than once when used with OR statements. Filters with different names should be applied with AND statements. . Defaults to None.
        next_token(str, optional): An enumeration token that, when provided in a request, returns the next batch of the results. Defaults to None.
        max_results(int, optional): A non-negative integer used to limit the number of returned results. The maximum number of results that can be returned is 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codestar_notification.target.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codestar_notification.target.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codestar-notifications",
        operation="list_targets",
        op_kwargs={
            "Filters": filters,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
