"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def tag(hub, ctx, arn: str, tags: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Associates a set of provided tags with a notification rule.

    Args:
        arn(str): The Amazon Resource Name (ARN) of the notification rule to tag.
        tags(Dict): The list of tags to associate with the resource. Tag key names cannot start with "aws".

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codestar_notification.resource.tag(ctx, arn=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codestar_notification.resource.tag arn=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codestar-notifications",
        operation="tag_resource",
        op_kwargs={"Arn": arn, "Tags": tags},
    )


async def untag(hub, ctx, arn: str, tag_keys: List) -> Dict:
    r"""
    **Autogenerated function**

    Removes the association between one or more provided tags and a notification rule.

    Args:
        arn(str): The Amazon Resource Name (ARN) of the notification rule from which to remove the tags.
        tag_keys(List): The key names of the tags to remove.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codestar_notification.resource.untag(
                ctx, arn=value, tag_keys=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codestar_notification.resource.untag arn=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codestar-notifications",
        operation="untag_resource",
        op_kwargs={"Arn": arn, "TagKeys": tag_keys},
    )
