"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def subscribe(
    hub, ctx, arn: str, target: Dict, client_request_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an association between a notification rule and an SNS topic so that the associated target can receive notifications when the events described in the rule are triggered.

    Args:
        arn(str): The Amazon Resource Name (ARN) of the notification rule for which you want to create the association.
        target(Dict): Information about the SNS topics associated with a notification rule.
        client_request_token(str, optional): An enumeration token that, when provided in a request, returns the next batch of the results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codestar_notification.init.subscribe(
                ctx, arn=value, target=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codestar_notification.init.subscribe arn=value, target=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codestar-notifications",
        operation="subscribe",
        op_kwargs={
            "Arn": arn,
            "Target": target,
            "ClientRequestToken": client_request_token,
        },
    )


async def unsubscribe(hub, ctx, arn: str, target_address: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes an association between a notification rule and an Amazon SNS topic so that subscribers to that topic stop receiving notifications when the events described in the rule are triggered.

    Args:
        arn(str): The Amazon Resource Name (ARN) of the notification rule.
        target_address(str): The ARN of the SNS topic to unsubscribe from the notification rule.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codestar_notification.init.unsubscribe(
                ctx, arn=value, target_address=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codestar_notification.init.unsubscribe arn=value, target_address=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codestar-notifications",
        operation="unsubscribe",
        op_kwargs={"Arn": arn, "TargetAddress": target_address},
    )
