"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "event_type"


async def list_all(
    hub, ctx, filters: List = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the event types available for configuring notifications.

    Args:
        filters(List, optional): The filters to use to return information by service or resource type. Defaults to None.
        next_token(str, optional): An enumeration token that, when provided in a request, returns the next batch of the results. Defaults to None.
        max_results(int, optional): A non-negative integer used to limit the number of returned results. The default number is 50. The maximum number of results that can be returned is 100. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codestar_notification.event_type_.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codestar_notification.event_type.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codestar-notifications",
        operation="list_event_types",
        op_kwargs={
            "Filters": filters,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
