"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    provider_type: str,
    provider_endpoint: str,
    vpc_configuration: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a resource that represents the infrastructure where a third-party provider is installed. The host is used when you create connections to an installed third-party provider type, such as GitHub Enterprise Server. You create one host for all connections to that provider.  A host created through the CLI or the SDK is in `PENDING` status by default. You can make its status `AVAILABLE` by setting up the host in the console.

    Args:
        name(str): The name of the host to be created. The name must be unique in the calling AWS account.
        provider_type(str): The name of the installed provider to be associated with your connection. The host resource represents the infrastructure where your provider type is installed. The valid provider type is GitHub Enterprise Server.
        provider_endpoint(str): The endpoint of the infrastructure to be represented by the host after it is created.
        vpc_configuration(Dict, optional): The VPC configuration to be provisioned for the host. A VPC must be configured and the infrastructure to be represented by the host must already be connected to the VPC. Defaults to None.
        tags(List, optional): . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codestar_connection.host.create(
                ctx, name=value, provider_type=value, provider_endpoint=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codestar_connection.host.create name=value, provider_type=value, provider_endpoint=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codestar-connections",
        operation="create_host",
        op_kwargs={
            "Name": name,
            "ProviderType": provider_type,
            "ProviderEndpoint": provider_endpoint,
            "VpcConfiguration": vpc_configuration,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, host_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    The host to be deleted. Before you delete a host, all connections associated to the host must be deleted.  A host cannot be deleted if it is in the VPC_CONFIG_INITIALIZING or VPC_CONFIG_DELETING state.

    Args:
        host_arn(str): The Amazon Resource Name (ARN) of the host to be deleted.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codestar_connection.host.delete(ctx, host_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codestar_connection.host.delete host_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codestar-connections",
        operation="delete_host",
        op_kwargs={"HostArn": host_arn},
    )


async def get(hub, ctx, host_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the host ARN and details such as status, provider type, endpoint, and, if applicable, the VPC configuration.

    Args:
        host_arn(str): The Amazon Resource Name (ARN) of the requested host.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codestar_connection.host.get(ctx, host_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codestar_connection.host.get host_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codestar-connections",
        operation="get_host",
        op_kwargs={"HostArn": host_arn},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the hosts associated with your account.

    Args:
        max_results(int, optional): The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.
        next_token(str, optional): The token that was returned from the previous ListHosts call, which can be used to return the next set of hosts in the list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codestar_connection.host.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codestar_connection.host.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codestar-connections",
        operation="list_hosts",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def update(
    hub,
    ctx,
    host_arn: str,
    provider_endpoint: str = None,
    vpc_configuration: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a specified host with the provided configurations.

    Args:
        host_arn(str): The Amazon Resource Name (ARN) of the host to be updated.
        provider_endpoint(str, optional): The URL or endpoint of the host to be updated. Defaults to None.
        vpc_configuration(Dict, optional): The VPC configuration of the host to be updated. A VPC must be configured and the infrastructure to be represented by the host must already be connected to the VPC. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codestar_connection.host.update(ctx, host_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codestar_connection.host.update host_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codestar-connections",
        operation="update_host",
        op_kwargs={
            "HostArn": host_arn,
            "ProviderEndpoint": provider_endpoint,
            "VpcConfiguration": vpc_configuration,
        },
    )
