"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    connection_name: str,
    provider_type: str = None,
    tags: List = None,
    host_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a connection that can then be given to other AWS services like CodePipeline so that it can access third-party code repositories. The connection is in pending status until the third-party connection handshake is completed from the console.

    Args:
        provider_type(str, optional): The name of the external provider where your third-party code repository is configured. Defaults to None.
        connection_name(str): The name of the connection to be created. The name must be unique in the calling AWS account.
        tags(List, optional): The key-value pair to use when tagging the resource. Defaults to None.
        host_arn(str, optional): The Amazon Resource Name (ARN) of the host associated with the connection to be created. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codestar_connection.connection.create(
                ctx, connection_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codestar_connection.connection.create connection_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codestar-connections",
        operation="create_connection",
        op_kwargs={
            "ProviderType": provider_type,
            "ConnectionName": connection_name,
            "Tags": tags,
            "HostArn": host_arn,
        },
    )


async def delete(hub, ctx, connection_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    The connection to be deleted.

    Args:
        connection_arn(str): The Amazon Resource Name (ARN) of the connection to be deleted.  The ARN is never reused if the connection is deleted. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codestar_connection.connection.delete(ctx, connection_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codestar_connection.connection.delete connection_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codestar-connections",
        operation="delete_connection",
        op_kwargs={"ConnectionArn": connection_arn},
    )


async def get(hub, ctx, connection_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the connection ARN and details such as status, owner, and provider type.

    Args:
        connection_arn(str): The Amazon Resource Name (ARN) of a connection.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codestar_connection.connection.get(ctx, connection_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codestar_connection.connection.get connection_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codestar-connections",
        operation="get_connection",
        op_kwargs={"ConnectionArn": connection_arn},
    )


async def list_all(
    hub,
    ctx,
    provider_type_filter: str = None,
    host_arn_filter: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the connections associated with your account.

    Args:
        provider_type_filter(str, optional): Filters the list of connections to those associated with a specified provider, such as Bitbucket. Defaults to None.
        host_arn_filter(str, optional): Filters the list of connections to those associated with a specified host. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned nextToken value. Defaults to None.
        next_token(str, optional): The token that was returned from the previous ListConnections call, which can be used to return the next set of connections in the list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codestar_connection.connection.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codestar_connection.connection.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codestar-connections",
        operation="list_connections",
        op_kwargs={
            "ProviderTypeFilter": provider_type_filter,
            "HostArnFilter": host_arn_filter,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
