"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    user_arn: str,
    display_name: str,
    email_address: str,
    ssh_public_key: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a profile for a user that includes user preferences, such as the display name and email address assocciated with the user, in AWS CodeStar. The user profile is not project-specific. Information in the user profile is displayed wherever the user's information appears to other users in AWS CodeStar.

    Args:
        user_arn(str): The Amazon Resource Name (ARN) of the user in IAM.
        display_name(str): The name that will be displayed as the friendly name for the user in AWS CodeStar. .
        email_address(str): The email address that will be displayed as part of the user's profile in AWS CodeStar.
        ssh_public_key(str, optional): The SSH public key associated with the user in AWS CodeStar. If a project owner allows the user remote access to project resources, this public key will be used along with the user's private key for SSH access. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codestar.user_profile.create(
                ctx, user_arn=value, display_name=value, email_address=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codestar.user_profile.create user_arn=value, display_name=value, email_address=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codestar",
        operation="create_user_profile",
        op_kwargs={
            "userArn": user_arn,
            "displayName": display_name,
            "emailAddress": email_address,
            "sshPublicKey": ssh_public_key,
        },
    )


async def delete(hub, ctx, user_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a user profile in AWS CodeStar, including all personal preference data associated with that profile, such as display name and email address. It does not delete the history of that user, for example the history of commits made by that user.

    Args:
        user_arn(str): The Amazon Resource Name (ARN) of the user to delete from AWS CodeStar.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codestar.user_profile.delete(ctx, user_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codestar.user_profile.delete user_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codestar",
        operation="delete_user_profile",
        op_kwargs={"userArn": user_arn},
    )


async def describe(hub, ctx, user_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a user in AWS CodeStar and the user attributes across all projects.

    Args:
        user_arn(str): The Amazon Resource Name (ARN) of the user.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codestar.user_profile.describe(ctx, user_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codestar.user_profile.describe user_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codestar",
        operation="describe_user_profile",
        op_kwargs={"userArn": user_arn},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists all the user profiles configured for your AWS account in AWS CodeStar.

    Args:
        next_token(str, optional): The continuation token for the next set of results, if the results cannot be returned in one response. Defaults to None.
        max_results(int, optional): The maximum number of results to return in a response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codestar.user_profile.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codestar.user_profile.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codestar",
        operation="list_user_profiles",
        op_kwargs={"nextToken": next_token, "maxResults": max_results},
    )


async def update(
    hub,
    ctx,
    user_arn: str,
    display_name: str = None,
    email_address: str = None,
    ssh_public_key: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a user's profile in AWS CodeStar. The user profile is not project-specific. Information in the user profile is displayed wherever the user's information appears to other users in AWS CodeStar.

    Args:
        user_arn(str): The name that will be displayed as the friendly name for the user in AWS CodeStar.
        display_name(str, optional): The name that is displayed as the friendly name for the user in AWS CodeStar. Defaults to None.
        email_address(str, optional): The email address that is displayed as part of the user's profile in AWS CodeStar. Defaults to None.
        ssh_public_key(str, optional): The SSH public key associated with the user in AWS CodeStar. If a project owner allows the user remote access to project resources, this public key will be used along with the user's private key for SSH access. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codestar.user_profile.update(ctx, user_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codestar.user_profile.update user_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codestar",
        operation="update_user_profile",
        op_kwargs={
            "userArn": user_arn,
            "displayName": display_name,
            "emailAddress": email_address,
            "sshPublicKey": ssh_public_key,
        },
    )
