"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(
    hub,
    ctx,
    project_id: str,
    user_arn: str,
    project_role: str,
    client_request_token: str = None,
    remote_access_allowed: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds an IAM user to the team for an AWS CodeStar project.

    Args:
        project_id(str): The ID of the project to which you will add the IAM user.
        client_request_token(str, optional): A user- or system-generated token that identifies the entity that requested the team member association to the project. This token can be used to repeat the request. Defaults to None.
        user_arn(str): The Amazon Resource Name (ARN) for the IAM user you want to add to the AWS CodeStar project.
        project_role(str): The AWS CodeStar project role that will apply to this user. This role determines what actions a user can take in an AWS CodeStar project.
        remote_access_allowed(bool, optional): Whether the team member is allowed to use an SSH public/private key pair to remotely access project resources, for example Amazon EC2 instances. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codestar.team_member.associate(
                ctx, project_id=value, user_arn=value, project_role=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codestar.team_member.associate project_id=value, user_arn=value, project_role=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codestar",
        operation="associate_team_member",
        op_kwargs={
            "projectId": project_id,
            "clientRequestToken": client_request_token,
            "userArn": user_arn,
            "projectRole": project_role,
            "remoteAccessAllowed": remote_access_allowed,
        },
    )


async def disassociate(hub, ctx, project_id: str, user_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes a user from a project. Removing a user from a project also removes the IAM policies from that user that allowed access to the project and its resources. Disassociating a team member does not remove that user's profile from AWS CodeStar. It does not remove the user from IAM.

    Args:
        project_id(str): The ID of the AWS CodeStar project from which you want to remove a team member.
        user_arn(str): The Amazon Resource Name (ARN) of the IAM user or group whom you want to remove from the project.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codestar.team_member.disassociate(
                ctx, project_id=value, user_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codestar.team_member.disassociate project_id=value, user_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codestar",
        operation="disassociate_team_member",
        op_kwargs={"projectId": project_id, "userArn": user_arn},
    )


async def list_all(
    hub, ctx, project_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all team members associated with a project.

    Args:
        project_id(str): The ID of the project for which you want to list team members.
        next_token(str, optional): The continuation token for the next set of results, if the results cannot be returned in one response. Defaults to None.
        max_results(int, optional): The maximum number of team members you want returned in a response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codestar.team_member.list_all(ctx, project_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codestar.team_member.list_all project_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codestar",
        operation="list_team_members",
        op_kwargs={
            "projectId": project_id,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    project_id: str,
    user_arn: str,
    project_role: str = None,
    remote_access_allowed: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a team member's attributes in an AWS CodeStar project. For example, you can change a team member's role in the project, or change whether they have remote access to project resources.

    Args:
        project_id(str): The ID of the project.
        user_arn(str): The Amazon Resource Name (ARN) of the user for whom you want to change team membership attributes.
        project_role(str, optional): The role assigned to the user in the project. Project roles have different levels of access. For more information, see Working with Teams in the AWS CodeStar User Guide. Defaults to None.
        remote_access_allowed(bool, optional): Whether a team member is allowed to remotely access project resources using the SSH public key associated with the user's profile. Even if this is set to True, the user must associate a public key with their profile before the user can access resources. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codestar.team_member.update(
                ctx, project_id=value, user_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codestar.team_member.update project_id=value, user_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codestar",
        operation="update_team_member",
        op_kwargs={
            "projectId": project_id,
            "userArn": user_arn,
            "projectRole": project_role,
            "remoteAccessAllowed": remote_access_allowed,
        },
    )
