"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, id_: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the tags for a project.

    Args:
        id_(str): The ID of the project to get tags for.
        next_token(str, optional): Reserved for future use. Defaults to None.
        max_results(int, optional): Reserved for future use. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codestar.tags_for_project.list(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codestar.tags_for_project.list id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codestar",
        operation="list_tags_for_project",
        op_kwargs={"id": id_, "nextToken": next_token, "maxResults": max_results},
    )
