"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, project_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists resources associated with a project in AWS CodeStar.

    Args:
        project_id(str): The ID of the project.
        next_token(str, optional): The continuation token for the next set of results, if the results cannot be returned in one response. Defaults to None.
        max_results(int, optional): The maximum amount of data that can be contained in a single set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codestar.resource.list_all(ctx, project_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codestar.resource.list_all project_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codestar",
        operation="list_resources",
        op_kwargs={
            "projectId": project_id,
            "nextToken": next_token,
            "maxResults": max_results,
        },
    )
