"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    id_: str,
    description: str = None,
    client_request_token: str = None,
    source_code: List = None,
    toolchain: Dict = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a project, including project resources. This action creates a project based on a submitted project request. A set of source code files and a toolchain template file can be included with the project request. If these are not provided, an empty project is created.

    Args:
        name(str): The display name for the project to be created in AWS CodeStar.
        id_(str): The ID of the project to be created in AWS CodeStar.
        description(str, optional): The description of the project, if any. Defaults to None.
        client_request_token(str, optional): A user- or system-generated token that identifies the entity that requested project creation. This token can be used to repeat the request. Defaults to None.
        source_code(List, optional): A list of the Code objects submitted with the project request. If this parameter is specified, the request must also include the toolchain parameter. Defaults to None.
        toolchain(Dict, optional): The name of the toolchain template file submitted with the project request. If this parameter is specified, the request must also include the sourceCode parameter. Defaults to None.
        tags(Dict, optional): The tags created for the project. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codestar.project.create(ctx, name=value, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codestar.project.create name=value, id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codestar",
        operation="create_project",
        op_kwargs={
            "name": name,
            "id": id_,
            "description": description,
            "clientRequestToken": client_request_token,
            "sourceCode": source_code,
            "toolchain": toolchain,
            "tags": tags,
        },
    )


async def delete(
    hub, ctx, id_: str, client_request_token: str = None, delete_stack: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a project, including project resources. Does not delete users associated with the project, but does delete the IAM roles that allowed access to the project.

    Args:
        id_(str): The ID of the project to be deleted in AWS CodeStar.
        client_request_token(str, optional): A user- or system-generated token that identifies the entity that requested project deletion. This token can be used to repeat the request. . Defaults to None.
        delete_stack(bool, optional): Whether to send a delete request for the primary stack in AWS CloudFormation originally used to generate the project and its resources. This option will delete all AWS resources for the project (except for any buckets in Amazon S3) as well as deleting the project itself. Recommended for most use cases. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codestar.project.delete(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codestar.project.delete id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codestar",
        operation="delete_project",
        op_kwargs={
            "id": id_,
            "clientRequestToken": client_request_token,
            "deleteStack": delete_stack,
        },
    )


async def describe(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes a project and its resources.

    Args:
        id_(str): The ID of the project.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codestar.project.describe(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codestar.project.describe id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codestar",
        operation="describe_project",
        op_kwargs={"id": id_},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists all projects in AWS CodeStar associated with your AWS account.

    Args:
        next_token(str, optional): The continuation token to be used to return the next set of results, if the results cannot be returned in one response. Defaults to None.
        max_results(int, optional): The maximum amount of data that can be contained in a single set of results. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codestar.project.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codestar.project.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codestar",
        operation="list_projects",
        op_kwargs={"nextToken": next_token, "maxResults": max_results},
    )


async def tag(hub, ctx, id_: str, tags: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Adds tags to a project.

    Args:
        id_(str): The ID of the project you want to add a tag to.
        tags(Dict): The tags you want to add to the project.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codestar.project.tag(ctx, id_=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codestar.project.tag id_=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codestar",
        operation="tag_project",
        op_kwargs={"id": id_, "tags": tags},
    )


async def untag(hub, ctx, id_: str, tags: List) -> Dict:
    r"""
    **Autogenerated function**

    Removes tags from a project.

    Args:
        id_(str): The ID of the project to remove tags from.
        tags(List): The tags to remove from the project.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codestar.project.untag(ctx, id_=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codestar.project.untag id_=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codestar",
        operation="untag_project",
        op_kwargs={"id": id_, "tags": tags},
    )


async def update(hub, ctx, id_: str, name: str = None, description: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates a project in AWS CodeStar.

    Args:
        id_(str): The ID of the project you want to update.
        name(str, optional): The name of the project you want to update. Defaults to None.
        description(str, optional): The description of the project, if any. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codestar.project.update(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codestar.project.update id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codestar",
        operation="update_project",
        op_kwargs={"id": id_, "name": name, "description": description},
    )
